<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 04. Jan. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * TableCell class file.
 * 
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: TableCell.php 249 2007-07-31 08:36:12Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_table
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: TableCell.php 249 2007-07-31 08:36:12Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */

/**
 * 
 */
require_once 'OpenDocumentPHP/OpenDocumentArchive.php';
require_once 'OpenDocumentPHP/util/Namespaces.php';
require_once 'OpenDocumentPHP/util/ODPElement.php';

/**
 * TableCell class.
 *  
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_table
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 * @todo        This class is highly experimental, outdated and should be updated soon.
 */
class TableCell extends ODPElement implements Namespaces 
{
	
	/**
     * 
     */
	private $x;
	
	/**
     * 
     */
	private $y;
	
	/**     
     * 
     */
	private $root;
	
	/**
     * 
     */
	private $content;
	
	/**
	 * 
	 */
    private $type;
    
    /**
     * 
     */
    private $link;
    
	/**
	 * @access protected
	 * @var integer	$spannedRows Numbers of spanned rows
	 */
	protected $spannedRows;
	
	/**
	 * @access protected
	 * @var integer	$spannedCols Number of spanned columns
	 */
	protected $spannedCols;
	
	/**
	 * @access protected
	 * @var integer $decimal Number of decimals of a number. 
	 */
	protected $decimal;
	
	/**
	 * 
	 */
    function __construct($elem = null,$x,$y)
    {  
        if (is_null($elem)) {
            parent::__construct('table:table-cell', '', self::TABLE);
        } else {
            parent::__construct($elem);         
        }
		$this->x = $x;
		$this->y = $y;
	}
	
	/**
     * 
     */
	function setContent($content) {
		$this->content = $content;
	}
	
	/**
	 * Set a hyperlink with text $content and URI $link into a cell 
	 * 
	 * @param  string $link    URI of the hyperlink where it links to
	 * @param  string $content text of the hyperlink which is displayed.
	 * @since  0.6.0 - 25. Jul. 2007
	 */
	function setLinkContent($link, $content)
	{
	   $this->content = $content;
	   $this->link = $link;
	   $this->type = 'hyperlink';
	}
	
	/**
     * 
     */
	function setDecimal($decimal) {
		$this->content = number_format($this->content, $decimal);
		$this->decimal = $decimal;
	}
	
	/**
     * 
     */
	function getContent() {
		return $this->content;
	}
	
	/**
	 * @todo NOT IMPLEMENTED NOW
	 */
	function setFontBold() {
	}
	
	/**
	 * @todo NOT IMPLEMENTED NOW
	 */
	function setFontItalic() {
	}
	
	/**
	 * @todo NOT IMPLEMENTED NOW
	 */
	function setTextCenter() {
	}
	
	/**
	 *
	 * @access 	public
	 * @return 	integer						
	 */
	public function getSpannedRows() {
		return $this->spannedRows;
	}
	
	/**
	 * @access 	public
	 * @return 	integer								
	 */
	public function getSpannedCols() {
		return $this->spannedCols;
	}
	
	/**
     * 
     */
	function getCellType() {
        if (isset($this->type)) {
              $type = $this->type;
        } else {       
            $content = $this->content;
            $type = 'string';
            if (is_float($content) || is_numeric($content) || is_int($content)) {
                $type = 'float';
            } else {
            
            }
		}
		return $type;
	}
	
	/**
     * 
     */
	function getDocumentFragment() {
		$content = $this->content;
		$type = $this->getCellType();
		if ($this->getSpannedRows() > 1) {
			$this->root->setAttributeNS(self :: TABLE, 'table:number-rows-spanned', $this->getSpannedRows());
		}
		if ($this->getSpannedCols() > 1) {
			$this->root->setAttributeNS(self :: TABLE, 'table:number-columns-spanned', $this->getSpannedCols());
		}
		switch ($type) {
			case 'float' :
				$this->root->setAttributeNS(self :: OFFICE, 'office:value-type', $type);
				$this->root->setAttributeNS(self :: OFFICE, 'office:value', $content);
                if ($content != '') {
                    $text = $this->domFragment->createElementNS(self :: TEXT, 'text:p', $content);                    
                    $this->root->appendChild($text);
                }
                break;
                				
			case 'hyperlink' :
                if ($content != '') {
                    $this->root->setAttributeNS(self :: OFFICE, 'office:value-type', 'string');                                    
                    $text = $this->domFragment->createElementNS(self :: TEXT, 'text:p');                    
                    $anchor = $this->domFragment->createElementNS(self::TEXT, 'text:a', $content);
                    $anchor->setAttributeNS(self::XLINK, 'link:href', $this->link);
                    $text->appendChild($anchor);
                    $this->root->appendChild($text);
                }
                break;                    
                
		    case 'string' :
			default :
				if ($content != '') {
                    $this->root->setAttributeNS(self :: OFFICE, 'office:value-type', 'string');                                 
				    $text = $this->domFragment->createElementNS(self :: TEXT, 'text:p', $content);					
					$this->root->appendChild($text);
				}
		}
		return $this->root;
	}
}
?>
